package gov.va.med.mhv.sm.admin.model;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.SelectBeforeUpdate;
import org.hibernate.annotations.Type;

import gov.va.med.mhv.common.data.model.AbstractBaseEntity;
import gov.va.med.mhv.sm.admin.enums.MessageFilterEnum;
import gov.va.med.mhv.sm.admin.enums.MessagesOrderByEnum;
import gov.va.med.mhv.sm.admin.enums.SortOrderEnum;

@Entity
@Table(name = "FOLDER")
@DynamicUpdate(value=true)
@SelectBeforeUpdate(value=true) 
public class Folder extends AbstractBaseEntity{

	private static final long serialVersionUID = 9033170567549138201L;
	
	@Id
	@Column(name = "FOLDER_ID")
	@GeneratedValue(strategy=GenerationType.SEQUENCE, generator="sequence")
	@SequenceGenerator(name="sequence", sequenceName="GEN_SMS_SEQ")
	private Long id;
	
	@Column(name = "ACTIVE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean active;
	
	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;
	
	@Transient
	private int count;

	@Transient
	protected Long currentSubFolderId;

	@Transient
	protected MessageFilterEnum filter;
	
	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;
	
	@Column(name = "FOLDER_NAME")
	private String name;
	
	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@Transient
	protected MessagesOrderByEnum orderBy;
	
	@ManyToOne
	@JoinColumn(name = "USER_ID")
	private SMUser owner;

	@Transient
	protected SortOrderEnum sortOrder;

	@Transient
	protected List<SubFolder> subfolderList;

	@Transient
	protected boolean systemFolder = false;
	
	@Transient
	protected int unreadCount;

	@Column(name = "USER_ID", insertable = false, updatable = false)
	private Long userId;

	public Folder(){
		this.active=true;
		this.createdDate=new Date();
		this.modifiedDate=new Date();
		this.filter = MessageFilterEnum.ALL;
		this.orderBy = MessagesOrderByEnum.DATE;
		this.sortOrder = SortOrderEnum.DESC;
	}
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Boolean getActive() {
		return active;
	}

	public void setActive(Boolean active) {
		this.active = active;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public SMUser getOwner() {
		return owner;
	}

	public void setOwner(SMUser owner) {
		this.owner = owner;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public int getCount() {
		return count;
	}

	public void setCount(int count) {
		this.count = count;
	}

	public int getUnreadCount() {
		return unreadCount;
	}

	public void setUnreadCount(int unreadCount) {
		this.unreadCount = unreadCount;
	}

	public boolean isSystemFolder() {
		return systemFolder;
	}

	public void setSystemFolder(boolean systemFolder) {
		this.systemFolder = systemFolder;
	}

	public MessageFilterEnum getFilter() {
		return filter;
	}

	public void setFilter(MessageFilterEnum filter) {
		this.filter = filter;
	}

	public MessagesOrderByEnum getOrderBy() {
		return orderBy;
	}

	public void setOrderBy(MessagesOrderByEnum orderBy) {
		this.orderBy = orderBy;
	}

	public SortOrderEnum getSortOrder() {
		return sortOrder;
	}

	public void setSortOrder(SortOrderEnum sortOrder) {
		this.sortOrder = sortOrder;
	}

	public List<SubFolder> getSubfolderList() {
		return subfolderList;
	}

	public void setSubfolderList(List<SubFolder> subfolderList) {
		this.subfolderList = subfolderList;
	}

	public Long getCurrentSubFolderId() {
		return currentSubFolderId;
	}

	public void setCurrentSubFolderId(Long currentSubFolderId) {
		this.currentSubFolderId = currentSubFolderId;
	}
	
	public static final Comparator<Folder> USER_FOLDER_SORTER = new Comparator<Folder>() {
		public int compare(Folder a, Folder b) {
			if(a == null || b == null) return 0;
			return a.getName().toUpperCase(Locale.ENGLISH).compareTo(b.getName().toUpperCase(Locale.ENGLISH));
		}
	};

}
